<x-user.content>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:head> </x-slot:head>
    <div class="container-fluid">
        <div class="row px-xl-5">
            <div class="col-12">
                <nav class="breadcrumb bg-light mb-30">
                    <a class="breadcrumb-item text-dark" href="/">Home</a>
                    <span class="breadcrumb-item active">Item Hadiah</span>
                </nav>
            </div>
        </div>
    </div>

    <div class="container-fluid pt-5 pb-3" id="prod">
        <div class="row px-xl-5">

            @forelse ($item as $p)
                <div class="col-lg-2 col-md-4 col-sm-6 pb-1">
                    <div class="product-item bg-light mb-4">
                        <div class="product-img position-relative overflow-hidden">
                            @if ($p->gambar != null)
                                <img class="img-fluid w-100" src="{{ asset('/storage/produk/' . $p->gambar) }}"
                                    alt="produk">
                            @else
                                <img alt="produk" class="img-fluid w-100"
                                    src="{{ asset('storage/produk/produk.jpg') }}">
                            @endif
                            <div class="product-action">

                                <a class="btn btn-outline-dark btn-square" href="detail-item/{{ $p->link_hadiah }}"><i
                                        class="fa fa-search"></i></a>
                            </div>
                        </div>
                        <div class="text-center py-4">
                            <a class="h6 text-decoration-none text-truncate" href="detail-item/{{ $p->link_hadiah }}">
                                @if (strlen($p->nm_hadiah) > 30)
                                    {{ substr($p->nm_hadiah, 0, -22) }}...
                                @else
                                    {{ $p->nm_hadiah }}
                                @endif
                            </a>
                            <div class="d-flex align-items-center justify-content-center mt-2">
                                <h5>
                                    {{ number_format($p->poin, 0, ',', '.') }} Poin
                                </h5>

                            </div>


                        </div>
                    </div>
                </div>

            @empty
                <div class="text-center d-flex justify-item-center">
                    <h2> Produk tidak ditemukan</h2>
                </div>
            @endforelse
        </div>

        <div class="container d-flex justify-content-center">
            {{ $item->links('components.admin.pagination') }}
        </div>
    </div>


    <div class="vh-100"></div>

    <x-slot:foot> </x-slot:foot>
</x-user.content>
